param ($source, $target, [int64] $size, $time, [int64] $failed, [int64] $skipped)

write-host "Transfer completed:"
write-host "  Source: $source"
write-host "  Target: $target"
write-host "  Failed: $failed, skipped: $skipped"

$fsize = "{0:N0}" -f $size
write-host "  Size: $fsize"
write-host "  Time: $time"
write-host ""

write-host "Sending notification..."

$topic = 'codesector_test'
# 'YOUR_TOPIC'

if ($key -eq 'YOUR_TOPIC') {
    write-host "Please subscribe to a topic in the Ntfy mobile app or at https://ntfy.sh/app"

    [void][System.Console]::ReadKey($true)
    exit
}

$url = "https://ntfy.sh/$topic"

$headers = @{
    "Title" = "Transfer completed"
    "Priority" = "default"
    "Tags" = "heavy_check_mark"
}

$body = @"
Source: $source
Target: $target
$size bytes, $time
Failed: $failed, skipped: $skipped
"@

$response = Invoke-WebRequest -Method Post -Uri $url -Headers $headers -Body $body

write-host $response

Start-Sleep -Seconds 5
